

#|____________________________________________________________________
 |
 |              RMDS.LSP - Multidimensional Scaling
 |
 |    Performs Classical or Replicated metric or nonmetric MDS
 |        Uses Kruskal's secondary monotone transformation 
 |            and the Guttman-deLeeuw SMACOF algorithm
 |              Copyright (c) 1997, Forrest W. Young, 
 |                Pedro Valero-Mora & Ruben Ledesma
 |
 |                  This is the main MDS Program.
 |      This program replaces the previous ViSta|MDS program.
 |           which is now called AMDS, for Averaged MDS
 |
 |                       PLUGIN LOADER FILE
 |
 | Replaces MDS.LSP which implemented metric unreplicated MDS
 | using the SMACOF algorithm. The code was very unstructured.
 |
 | RMDS Version 1.0 - Forrest Young  May 1997
 | RMDS Version 1.1 - Pedro   Valero Feb 2001
 | RMDS Version 1.2 - Forrest Young  Oct 2001
 | RMDS Version 1.3 - Forrest Young  Feb 2002
 | RMDS Version 1.4 - Forrest Young  May 2002
 | RMDS Version 1.5 - Forrest Young  Oct 2002
 | 
 | This is the plugin loader function file
 |_____________________________________________________________________
 |#


(let ((plugin-subdirectory "nrmds")
      (plugin-file         "nrmds5a0-construct")
      (menu-item           "Multidimensional Scaling")
      (toolbar-button      "MDScal")
      (workmap-icon        "MDS")
      (data-types        '("matrix"))
      (variable-types    '(numeric)))
  (send *vista* :prepare-plugin-environment
        plugin-subdirectory
        plugin-file 
        menu-item 
        toolbar-button
        workmap-icon
        data-types 
        variable-types))
  
(defun Multidimensional-Scaling
  (&key (data *current-data*) 
        (dialog nil)
        (dimensions 3)            
        (monotone nil)            
        (iteration-plot nil)                
        (iteration-report t)
        (niter 30)                
        (min-stress .001)
        (min-x-delta .001)        
        (min-stress-delta .0001))
"Args: (&key (data *current-data*) (dialog t) (dimensions 3) (monotone nil)  
             (iteration-plot nil) (iteration-report t) 
             (niter 30) (min-stress .001)
             (min-x-delta .001) (min-stress-delta .0001))

Performs Metric or Nonmetric Multidimensional Scaling on one or more square symmetric matrices of dissimilarities. The analysis is replicated when there is more than one matrix (e.g. the dissimilarity matrices are not averaged). 
Keyword arguments are 
  DATA, followed by the name of the data to be analyzed (default: *current-data*). If the data object contains 1 matrix of dissimilarities the analysis is a metric or nonmetric, non-replicated MDS. If more than one matrix, the analysis is metric or nonmetric replicated MDS. A dialog box is presented to get argument values if DIAGLOG is T.

  DIMENSIONS sets the dimensionality of the analysis (default 3, minimum 1)
  MONOTONE is nil (default) for metric MDS, t for nonmetric MDS

  ITERATION-REPORT - Present and update a report during iterations.
  ITERATION-PLOT   - Present and update a visualization during iterations.

Stops iterating when any one of the following stopping criteria are satisfied:
  NITER, the number of iterations (default 30);  
  MIN-STRESS (default .001) the minimum stress for stopping iterations; 
  MIN-STRESS-DELTA (default .0001) the minimum change in stress from one iteration to the next for stopping iterations; and 
  MIN-X-DELTA (default .001) the minimum of the maximum absolute value change in coordinates for stopping iterations." 
#|
Places a list of results in results slot. Results list includes X, the NxR matrix of coordinates in Euclidean Space; D, the NxN matrix of Euclidean distances between those coordinates; T, the NxN matrix of transformed data (T= normalized DATA if monotone=nil); and Stress, the badness-of-fit.
Returns object identification.     
|#
    (format t "; CopyRt: NR-MDS Copyright (c) 1997-2002, by Forrest W. Young, Pedro Valero-Mora & Ruben Ledesma~%> ")

     (load *mdscal-plugin-constructor-file*)

     (multidimensional-scaling
      :data data                
      :dialog dialog
      :dimensions dimensions    
      :monotone monotone
      :iteration-plot iteration-plot                
      :iteration-report iteration-report
      :niter niter              
      :min-stress min-stress 
      :min-x-delta min-x-delta  
      :min-stress-delta min-stress-delta))